package name.panitz.rmi.game;
import javax.swing.*;
import java.awt.event.*;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Color;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import static java.awt.event.KeyEvent.*;

import name.panitz.animation.AnimatedJPanel;

public class BallGameClient extends AnimatedJPanel {
  final String name;
  BallGame game=null;
  final int width = 400;
  final int height = 300;

  BallGameClient(String host,String n){
    this.name=n;
    setFocusable(true);
    try {
      Registry registry = LocateRegistry.getRegistry(host);
      game = (BallGame) registry.lookup("ballgame");
    } catch (Exception e) {}

    addMouseListener(new MouseAdapter(){
      public void mouseClicked(MouseEvent e){
        try{game.createBall(name);}catch(Exception e1){}
      }
    });

    addKeyListener(new KeyAdapter(){
      public void keyReleased(KeyEvent e){
        try{
          switch (e.getKeyCode()){
            case VK_DOWN: game.move(name,0,2);break;
	    case VK_LEFT:game.move(name,-2,0);break;
            case VK_RIGHT:game.move(name,2,0);break;
            case VK_UP:game.move(name,0,-2);break;
          }
        }catch(Exception e1){System.out.println(e);}
      }
    });
  }

  public void paintComponent(Graphics g){
    g.setColor(Color.WHITE);
    g.fillRect(0,0,width,height);
    try{
      for (Dimension d:game.getBalls().values()){
        g.setColor(Color.RED);
        g.fillOval(d.height,d.width,10,10);
      }
    }catch (Exception e){}
  }

  public Dimension getPreferredSize(){
    return new Dimension(width,height);}

  public static void main(String[] args) {
    JFrame f = new JFrame();
    f.add(new BallGameClient(args[0],args[1]));
    f.pack();
    f.setVisible(true);
  }
  public void move(){}
}

