#ifndef __PARSLIB_H
#define __PARSLIB_H 

#include <vector>

using namespace std;
namespace name {namespace panitz{ namespace parser{

template <typename a>
class CAF {
  private: a(*f)();
  public:
    a result;
    a operator()(){
      if (result==NULL) result=f();
      return result;
    }
    CAF(a x):result(x){}
    CAF(a(*f)()){this->f=f;result=NULL;}
};

template <typename a>
CAF<a> caf(a(*f)()){return CAF<a>(f);}

template <typename a,typename b>
class ParsResult{
  public:
    a result;
    vector<b> furtherToken;
    bool failed;

    ParsResult(vector<b>& furtherToken)
     :furtherToken(furtherToken),failed(true){};
    ParsResult(a result,vector<b>& furtherToken) 
     :result(result),furtherToken(furtherToken),failed(false){}
};

template <typename a,typename b>
ParsResult<a,b>* fail(vector<b>& furtherToken){
  return new ParsResult<a,b>(furtherToken);
}

template <typename a,typename b>
class Parser{
  public: virtual ParsResult<a,b>* parse(vector<b>& xs)=0;
};

template <typename a>
class GetToken: public Parser<a,a>,public CAF<Parser<a,a>*>{
  private:
    a token;
    bool(*eq)(a,a);
  public:
    GetToken(a token,bool(*eq)(a,a))
     :CAF<Parser<a,a>*>(this),token(token),eq(eq){}

    ParsResult<a,a>* parse(vector<a>& xs){
      if (!xs.empty() && eq(token,xs[0])){
        a tok = xs[0];
        vector<a> restToken = vector<a>(xs.begin()+1,xs.end());
        return new ParsResult<a,a>(tok,restToken);
      }
      return fail<a,a>(xs);
    }
};

template <typename a>
CAF<Parser<a,a>*> getToken(a token,bool(*eq)(a,a)){
  return new GetToken<a>(token,eq);}

template <typename a,typename b,typename c>
class Seq
     :public Parser<pair<a,b>*,c >
     ,public CAF<Parser<pair<a,b>*,c>*>{

  private:
     CAF<Parser<a,c>*> p1;
     CAF<Parser<b,c>*> p2;

  public:
    Seq(CAF<Parser<a,c>*> p1
       ,CAF<Parser<b,c>*> p2):
       CAF<Parser<pair<a,b>*,c>*>(this)
	,p1(p1),p2(p2){}

    virtual ParsResult<pair<a,b>*,c>* parse(vector<c>& xs){
     ParsResult<a,c>* res1 = p1()->parse(xs);
     if (!res1->failed) {
        vector<c> further = res1->furtherToken;
        a r1 = res1->result;         

        ParsResult<b,c>* res2 = p2()->parse(further);
        if (!res2->failed){
         b r2 = res2->result;  
         vector<c> further = res2->furtherToken;
         delete res1;delete res2;
         return 
         new ParsResult<pair<a,b>*,c>(new pair<a,b>(r1,r2),further);
        }
        delete res2;
      }

      delete res1;
      return fail<pair<a,b>*,c>(xs);
    }
};

template <typename a,typename b,typename c>
CAF<Parser<pair<a,b>*,c>*> operator,
                (CAF<Parser<a,c>*>p1,CAF<Parser<b,c>*> p2){
  return ((Parser<pair<a,b>*,c>*)new Seq<a,b,c>(p1,p2));
}

template <typename A,typename B> 
class Either{
 public:
   bool isLeft;
   union LeftOrRight{A left;B right;} value;
   Either(bool isLeft):isLeft(isLeft){};
};

template <typename A,typename B> 
Either<A,B>* left(A v){
  Either<A,B>* result=new Either<A,B>(true);
  result->value.left=v;
}

template <typename A,typename B> 
Either<A,B>* right(B v){
  Either<A,B>* result=new Either<A,B>(false);
  result->value.right=v;
}

template <typename a,typename b,typename c>
class Alt:public Parser<Either<a,b>*,c>
         ,public CAF<Parser<Either<a,b>*,c>*>{
  private:
   CAF<Parser<a,c>*> p1;
   CAF<Parser<b,c>*> p2;
  public:
   Alt(CAF<Parser<a,c>*> p1, CAF<Parser<b,c>*> p2): 
      CAF<Parser<Either<a,b>*,c>*>(this),p1(p1),p2(p2){}

   virtual ParsResult<Either<a,b>*,c>* parse(vector<c>& xs){
     ParsResult<a,c>* res1 = p1()->parse(xs);
     if (!res1->failed) {
       vector<c> further = res1->furtherToken;
       a r1 = res1->result;
       delete res1;
       return new ParsResult<Either<a,b>*,c>(left<a,b>(r1),further);
     }
     delete res1;
     ParsResult<b,c>* res2 = p2()->parse(xs);
     if (!res2->failed) {
      b r2 = res2->result;
      vector<c> further = res2->furtherToken;
      delete res2;
      return new ParsResult<Either<a,b>*,c>(right<a,b>(r2),further);
     }
     delete res2;
     return fail<Either<a,b>*,c>(xs);
   }
};

template <typename a,typename b,typename c>
CAF<Parser<Either<a,b>*,c>*> 
  operator|(CAF<Parser<a,c>*>p1,CAF<Parser<b,c>*> p2){
  return ((Parser<Either<a,b>*,c>*)new Alt<a,b,c>(p1,p2));
}

template <typename a,typename b,typename c>
class Map:public Parser<b,c>,public CAF<Parser<b,c>*>{
  private:
    Parser<a,c>* p;
    b(*f)(a);

  public:
    Map(b(*f)(a),Parser<a,c>* p)
      :CAF<Parser<b,c>*>(this),f(f),p(p){}

    virtual ParsResult<b,c>* parse(vector<c>& xs){
      ParsResult<a,c>* res1 = p->parse(xs);

      if (!res1->failed){
        a r1 = res1->result;
        vector<c> further = res1->furtherToken;
        delete res1;
        return new ParsResult<b,c>((*f)(r1),further);
      }
      delete res1;
      return fail<b,c>(xs);
    }
};

template <typename a,typename b,typename c>
CAF<Parser<b,c>*> operator<<(CAF<Parser<a,c>*> p,  b(*f)(a)){
  return ((Parser<b,c>*)new Map<a,b,c>(f,p()));
}

template <typename a>
a getLeftRight(Either<a,a>* either){return either->value.left;}

template <typename a,typename c>
CAF<Parser<a,c>*> 
  operator||(CAF<Parser<a,c>*> p1,CAF<Parser<a,c>*> p2){
  return (p1|p2)<< getLeftRight<a>;
}

template <typename a,typename b>
class Result:public Parser<a,b>,public CAF<Parser<a,b>*>{
  public:
   a x;
   Result(a x):CAF<Parser<a,b>*>(this),x(x){}
   ParsResult<a,b>* parse(vector<b>& xs){
     return new ParsResult<a,b>(x,xs);}
};
}}}//namespace
#endif


