#include "../ParsLib.h"
#include <iostream>

using namespace name::panitz::parser ;

namespace pl0{

template <typename a> 
bool mkTrue(a x){return true;}

typedef Parser<bool,char>* CP;
typedef CAF<CP> P;

typedef pair<bool,bool>* pb2;
typedef pair<pair<bool,bool>*,bool>* pb3;
typedef pair<pair<pair<bool,bool>*,bool>*,bool>* pb4;
typedef pair<pair<pair<pair<bool,bool>*,bool>*,bool>*,bool>* pb5;

bool charEq(char c1,char c2){
return c1==c2;}

P epsilon = new Result<bool,char>(true);

P gC(char c){ return getToken(c,charEq) << mkTrue<char>;}

P whiteChar = gC(' ')||gC('\n')||gC('\t');

CP getWhiteSpace();
P whiteSpace = caf(getWhiteSpace);
CP getWhiteSpace(){return ((whiteChar,whiteSpace)<<mkTrue<pb2> ||epsilon)() ;}

P gwC(char c){return (whiteSpace,gC(c)) << mkTrue<pb2>;}

P ifT    = (gwC('I'),gC('F'))                        << mkTrue<pb2>;
P thenT  = (gwC('T'),gC('H'),gC('E'),gC('N'))        << mkTrue<pb4>;
P callT  = (gwC('C'),gC('A'),gC('L'),gC('L'))        << mkTrue<pb4>;
P whileT = (gwC('W'),gC('H'),gC('I'),gC('L'),gC('E'))<< mkTrue<pb5>;
P constT = (gwC('C'),gC('O'),gC('N'),gC('S'),gC('T'))<< mkTrue<pb5>;
P beginT = (gwC('B'),gC('E'),gC('G'),gC('I'),gC('N'))<< mkTrue<pb5>;
P oddT   = (gwC('O'),gC('D'),gC('D'))                << mkTrue<pb3>;
P endT   = (gwC('E'),gC('N'),gC('D'))                << mkTrue<pb3>;
P varT   = (gwC('V'),gC('A'),gC('R'))                << mkTrue<pb3>;
P doT    = (gwC('D'),gC('O'))                        << mkTrue<pb2>;

P procedureT = (gwC('P'),gC('R'),gC('O'),gC('C'),gC('E')
               ,gC('D'),gC('U'),gC('R'),gC('E')) 
   << mkTrue<pair<pair<pair<pair<pair<pair<pair<pair<bool,bool>*
      ,bool>*,bool>*,bool>*,bool>*,bool>*,bool>*,bool>*>;

P addT   = gwC('+');
P subT   = gwC('-');
P mulT   = gwC('*');
P divT   = gwC('/');
P eqT    = gwC('=');
P gtT    = gwC('>');
P ltT    = gwC('<');
P neqT   = (gwC('<'),gC('>'))                       <<mkTrue<pb2>;
P geT    = (gwC('>'),gC('='))                       <<mkTrue<pb2>;
P leT    = (gwC('<'),gC('='))                       <<mkTrue<pb2>;
P dotT   = gwC('.');
P commaT = gwC(',');
P semicolonT   = gwC(';');
P lparT  = gwC('(');
P rparT  = gwC(')');
P assignT= (gwC(':'),gC('='))                       <<mkTrue<pb2>;

P alphaT = gC('A')||gC('B')||gC('C')||gC('D')||gC('E')||gC('F')||gC('G')
         ||gC('H')||gC('I')||gC('J')||gC('K')||gC('L')||gC('M')||gC('N')
         ||gC('O')||gC('P')||gC('Q')||gC('R')||gC('S')||gC('T')||gC('U')
         ||gC('V')||gC('W')||gC('X')||gC('Y')||gC('Z');

P digitT = gC('0')||gC('1')||gC('2')||gC('3')||gC('4')||gC('5')||gC('6')
         ||gC('7')||gC('8')||gC('9');


CP getNumber();
P numberT=caf(getNumber);
CP getNumber(){return ((digitT,numberT)<<mkTrue<pb2>||digitT)();}
P wnumberT=(whiteSpace,numberT)        << mkTrue<pb2>;

CP getIdent();
P identT=caf(getIdent);
CP getIdent(){return ((alphaT,identT)<<mkTrue<pb2>||alphaT)();}
P widentT=(whiteSpace,identT)        << mkTrue<pb2>;

CP getExpression();                 P expression=caf(getExpression);
CP getTerm2();                      P term2 = caf(getTerm2);
CP getExpression2();                P expression2 = caf(getExpression2);
CP getStatement();                  P statement = caf(getStatement);
CP getStatementList();              P statementList = caf(getStatementList);
CP getBlock();                      P block=caf(getBlock);
CP getProcDecls();                  P procDecls=caf(getProcDecls);
CP getIdentList();                  P identList=caf(getIdentList);
CP getConstAssignList();            P constAssignList=caf(getConstAssignList);

P addOp  = addT || subT;
P mulOp  = mulT || divT;
P compOp = eqT  || neqT || geT  || leT  || gtT || ltT  ;

P factor = widentT || wnumberT || (lparT,expression,rparT)<<mkTrue<pb3>;

CP getTerm2(){return ((mulOp,factor,term2)<<mkTrue<pb3> || epsilon)();}

P term = (factor,term2) << mkTrue<pb2>;

CP getExpression2(){return ((addOp,term,expression2)<<mkTrue<pb3> || epsilon)();}

CP getExpression(){
 return( (term,expression2)                   <<mkTrue<pb2>
       ||(addOp,term,expression2)             <<mkTrue<pb3>)();}

P condition = (oddT,expression)               <<mkTrue<pb2> 
            ||(expression,compOp,expression)  <<mkTrue<pb3>;

CP getStatementList(){
 return ( (statement,semicolonT,statementList)<< mkTrue<pb3> 
        ||statement              )();}

P whileSt = (whileT,condition,doT,statement)  << mkTrue<pb4>;
P ifSt    = (ifT,condition,thenT,statement)   << mkTrue<pb4>;
P callSt  = (callT,widentT)                   << mkTrue<pb2>;
P assignSt= (widentT,assignT,expression)      << mkTrue<pb3>;
P blockSt = (beginT,statementList,endT)       << mkTrue<pb3>;

CP getStatement(){return (blockSt||callSt||ifSt||whileSt||assignSt||epsilon)();}

P procDecl = (procedureT,widentT,semicolonT,block,semicolonT) <<mkTrue<pb5>;

CP getProcDecls(){return ((procDecl,procDecls)<<mkTrue<pb2>||epsilon)();}

CP getIdentList(){return ((widentT,commaT,identList)<<mkTrue<pb3>||widentT)();}

P varDecl = (varT,identList,semicolonT)<<mkTrue<pb3>||epsilon;

CP getConstAssignList(){
 return ((widentT,eqT,wnumberT,commaT,constAssignList)<<mkTrue<pb5>
       ||(widentT,eqT,wnumberT)                       <<mkTrue<pb3>)();}

P constDecl = (constT,constAssignList,semicolonT)<<mkTrue<pb3> ||epsilon;

CP getBlock(){return ((constDecl,varDecl,procDecls,statement)<<mkTrue<pb4>)();}

P program = (block,dotT)<<mkTrue<pb2>;
}

int main(int argc,char** argv ){
  FILE *fp;
  fp = fopen(argv[1], "r");
  vector<char> xs;  

  int c = getc(fp);
  while (c != EOF) {
    xs.push_back((char)c);
    c = getc(fp);
  }

  cout<<pl0::program()->parse(xs)->failed<<endl;
  cout<<pl0::program()->parse(xs)->result<<endl;
  cout<<pl0::program()->parse(xs)->furtherToken[0]<<endl;
}


