package de.tfhberlin.panitz.vier;

public interface VierLogik {

    /**
       Sets a token of a certain player into a column of the board.

       @param column The column where to set the token. It is in
                     the range 1&lt;=column&lt;=Constants.COLUMNS.
       @param colour One of the colour 
                     constants: Constants.PLAYERONE and Constants.PLAYERTWO.
       @return The row in which the token lands. -1 if the column is full.
		     
     **/
  public int setChip(int column,byte colour);


    /**
       Tests if a player has won.

       @return true if one of the players has won.
     **/
  public boolean fourWins(); 

    /**
       Gives a String represntation of the complete board.

       It could be some representation like:

       <pre>  | | | | | | | |
 ---------------
 | | | | | | | |
 ---------------
 | | | |x|x| | |
 ---------------
 | | | |o|o| | |
 ---------------
 | | | |x|o| | |
 ---------------
 | | |x|o|o|x| |
 ---------------
</pre>

       @return A String, which has all information for the token on the board.
     **/
  public String toString();

}
