#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "gm.h"
#include "ccall.h"
#include "constants.h"

int nextHeap=0;
int heapSize=INITIALHeapSize;
int lastUsed=INITIALHeapSize;
int lastNeeded=5;

int* heap;
int* fromSpace;

int doTrace = 1;
void initGM(){
  heap =(int*)malloc(sizeof(int[INITIALHeapSize]));
}

int printNode(int a);
int getSize(int a);

int getAddress(int a){
  int data=heap[a];
  switch  (data){
    case IND: return getAddress(heap[a+1]);
    case IDN: return getAddress(heap[a+1]);
  }
  return a;
}

int nextStack=0;
const int maxStackSize=INITIALStackSize;
int stack [INITIALStackSize];
int stackBottom=0;

int stackSize(){
  return nextStack-stackBottom;
}



int pop(){
  nextStack=nextStack-1;
  return stack[nextStack];
}
void popn(int n){
  nextStack=nextStack-n;
}

int peek(int n){
  return stack[nextStack-1-n];
}


void push(int n){
  stack[nextStack]=n;
  nextStack=nextStack+1;
}

void dump(){
  //int sz=stackSize(); 
  push(pc);
  push(stackBottom);
  stackBottom=nextStack;
}
	
void restore(){
  nextStack=stackBottom;
  stackBottom=pop();
  pc=pop();	
}


void showStack(){
  int i=0;//stackBottom;
  printf("stack bottom %i\n:",stackBottom);
  for (;i<nextStack;i++)
    printf("%i -> %i\n",i,stack[i]);
}	


void showHeap(){
  printf("heapSize %i\n",nextHeap);
  printf("206851 %i %c\n",heap[206851],heap[206852]);
  int i=0;
  for (;i<nextHeap;){
    printf("%i -> ",i);
    i=i+printNode(i);
    printf(" %i nextH %i",i,nextHeap);
    printf(" special %i %c",heap[206851],heap[206852]);
    fflush(stdout);
    printf("ok\n");
    fflush(stdout);
  }
    printf("heap gedruckt\n");
  fflush(stdout);
}	

int printNode(int a){
  int nodeType = heap[a];
  int a1= heap[a+1];
  switch (nodeType){
    case IND: {printf("Ind %i",a1);return 2;}
    case IDN: {printf("Idn %i",a1);return heap[a+2];}
    case NUM: {printf("Num %i",a1);return 2;}
    case CHR: {printf("Chr %c",a1);return 2;}
    case CON:{
      printf("(");
      printf("%s",constructors[a1]);
      
      int i=0;
      int argc = heap[a+2];
      for (;i<heap[a+2];i++){
	printf(" %i",getAddress(heap[a+3+i]));
      }
      printf(")");		
      return argc+3;
    }
    case APP: {printf("App %i %i",a1,heap[a+2]);return 3;}
    case GLB: {printf("Glb %i %i",a1,heap[a+2]);return 3;}
  }
  printf("was ist das %i\n",nodeType);
  return 2;
}


void checkHeapBounds(int i,char* where){
  if (nextHeap+i>heapSize){
    fprintf(stderr,"Error: Heap size exceeded in %s neee %i new cells\n",where,i);
    fflush(stderr);
    exit(1);
  }
}
	
int nnum(int n){
  checkHeapBounds(2,"nnum");
  int result = nextHeap;
  heap[nextHeap]=NUM;
  heap[nextHeap+1]=n;
  nextHeap=nextHeap+2;
  return result;
}

int nchr(char n){
  checkHeapBounds(2,"nchr");
  int result = nextHeap;
  heap[nextHeap]=CHR;
  heap[nextHeap+1]=n;
  nextHeap=nextHeap+2;
  return result;
}

int nind(int n){
  checkHeapBounds(2,"nind");
  int result = nextHeap;
  heap[nextHeap]=IND;
  heap[nextHeap+1]=n;
  nextHeap=nextHeap+2;
  return result;
}

int nidn(int n,int l){
  checkHeapBounds(l,"nidn");
  int result = nextHeap;
  heap[nextHeap]=IDN;
  heap[nextHeap+1]=n;
  heap[nextHeap+2]=l;
  nextHeap=nextHeap+l;
  return result;
}

int napp(int n1,int n2){
  checkHeapBounds(3,"napp");
  int result = nextHeap;
  heap[nextHeap]=APP;
  heap[nextHeap+1]=n1;
  heap[nextHeap+2]=n2;
  nextHeap=nextHeap+3;
  return result;
}

int ncon(int n,int argc,int argv []){
  checkHeapBounds(argc+2,"ncon");
  int result = nextHeap;
  heap[nextHeap]=CON;
  heap[nextHeap+1]=n;
  heap[nextHeap+2]=argc;
  int i=0;
  for (;i<argc;i++){heap[nextHeap+3+i]=argv[i];}
  nextHeap=nextHeap+3+argc;
  return result;
}

int nglb(int argc,int code){
  checkHeapBounds(3,"nglb");
  int result = nextHeap;
  heap[nextHeap]=GLB;
  heap[nextHeap+1]=argc;
  heap[nextHeap+2]=code;
  nextHeap=nextHeap+3;
  return result;
}

void eval();
void unwind();

void check(int i);

void whnf(){
  int i = pc; 
  pc=-1000; 

  int a=getAddress(pop());
  dump();
  push(a);
  unwind();
  eval();
  pc=i; 
} 

void print(){
 startPrint:; 
  if (nextStack<=0){ return;}
  printf("startprint %d ",nextStack);
  int a = getAddress(pop());
  int nodeType = heap[a];
  switch (nodeType){
    case IND: {push(heap[a+1]);break;}
    case NUM: {printf("%i",heap[a+1]);break;}
    case CHR: {printf("%c",heap[a+1]);break;}
    case CON:
    {
      printf("(");
      printf("%s %d ",constructors[heap[a+1]],nextStack);
      
      int argsNr = heap[a+2];

      int ii=0;
      for (;ii<argsNr;ii++){
	push(getAddress(heap[a+3+ii]));
      }
      //	push(getAddress(heap[a+3+ii]));
      printf(" ");
      whnf();
      goto startPrint;//
	//printf("rekursive call nr %d from %d ",ii,argsNr);
	//print();

      printf(")");
      break;
    }

  default: printf("kann man nicht drucken %i\n",nodeType);
  }
}

void unwind(){
  static int count = 0;
 count++;
 startUnwind: ;
 // printf("%d\n",count);		
  int a = getAddress(pop());
  int nodeType = heap[a];
  switch (nodeType){
    case IND:{push(heap[a+1]);goto startUnwind;break;}
    case IDN:{push(heap[a+1]);goto startUnwind;break;}
    case APP:{
      push(a);
      push(heap[a+1]);			
      goto startUnwind;
      break;
    }
    case GLB:{
      int argc = heap[a+1];
      int cp = heap[a+2];
      int sSize=stackSize()+1;
      /*     if (sSize<=argc) {
        fprintf(stderr,"args stimmen nicht %i %i für %i\n",sSize,argc,cp);
        exit(1);}*/
       if (sSize>argc){
	int args[argc];
	int tmp=0;
	int i=argc-1;
	for (;i>=0;i--){
	  tmp=pop();
	  args[i]=heap[tmp+2];
	}
	if (argc>0)push(tmp);
	for (i=0;i<argc;i++)
          push(args[i]);
	pc=cp;

      }else{
	restore();
	push(a);
	goto startUnwind;
      }							
      break;
    }
    default:{
      if (stackBottom>0) {
        restore();
	push(a);
	pc=pc+1;
      }
    }
  }
  count--;
}

int add(int x, int y){return x+y;}
int sub(int x, int y){return x-y;}
int mult(int x, int y){return x*y;}
int divi(int x, int y){return x/y;}
int le(int x, int y){return x<=y;}
int ge(int x, int y){return x>=y;}
int lt(int x, int y){return x<y;}
int gt(int x, int y){return x>y;}
int eq(int x, int y){return x==y;}

void arithOp(int (*f)(int,int)){
  check(2);
  int x1=getAddress(pop());
  int x2=getAddress(pop());
  push(nnum(f(heap[x1+1],heap[x2+1])));
  pc=pc+1;
}

void compOp(int (*f)(int,int)){
  check(3);
  int x1=getAddress(pop());
  int x2=getAddress(pop());
  int argv[0];
  int name=f(heap[x1+1],heap[x2+1])?0:1;
  push(ncon(name,0,argv));
  pc=pc+1;
}

void step(){
  switch (code[pc]){
    case PUSHINT:    {
      check(2);
      push(nnum(code[pc+1]));
      pc=pc+2;
      break;
    }
    case PUSHCHAR:    {
      check(2);
      push(nchr(code[pc+1]));
      pc=pc+2;
      break;
    }
    case PUSH:    {
      push(peek(code[pc+1]));
      pc=pc+2;
      break;
    }
    case POP:    {	
      popn(code[pc+1]);
      pc=pc+2;
      break;
    }
    case SLIDE:    {	   
      int top=pop();
      popn(code[pc+1]);
      push(top);
      pc=pc+2;
      break;
    }
    case PACK:    {
      int name=code[pc+1];
      int argc=code[pc+2];
      check(3+argc);
      int argv [argc];
      int i=0;
      for (;i<argc;i++){
	argv[i]=pop();
      }
      int top=ncon(name,argc,argv);
      push(top);
      pc=pc+3;
      break;				
    }
    case ADD:  {arithOp(add);break;}
    case SUB:  {arithOp(sub);break;}
    case MULT: {arithOp(mult);break;}
    case DIV:  {arithOp(divi);break;}
    case LT:   {compOp(lt);break;}
    case GT:   {compOp(gt);break;}
    case LE:   {compOp(le);break;}
    case GE:   {compOp(ge);break;}
    case EQ:   {compOp(eq);break;}
    case PUSHGLOBAL:{push(code[pc+1]);pc=pc+2;break;}
    case MKAP:    {
      check(3);
      int a0=getAddress(pop());
      int a1=getAddress(pop());
      push(napp(a0,a1));
      pc=pc+1;
      break;
    }
    case UNWIND: {unwind();break;}
    case EVAL:    {
      int a=getAddress(pop());
      dump();
      push(a);
      unwind();
      break;
    }
    case UPDATE:    {
      int a = getAddress(pop());
      int n = peek(code[pc+1]);

      int size=getSize(n);
      heap[n]=(size==2)?IND:IDN;
      heap[n+1]=a;

      if (size>2) heap[n+2]=size; 

      pc=pc+2;
      break;
    }
    case JUMP:    {pc=pc+code[pc+1];break;}
    case CASEJUMP:{
      int name = heap[getAddress(peek(0))+1];
      int jumpc = code[pc+1];
      int i=0;
      int found=1;

      for (;i<jumpc;i++){
        if (code[pc+2+2*i]==name){
          pc=pc+code[pc+2+2*i+1];
          found=0;
          break;
        }
      }
      if (found!=0){
        fprintf(stderr,"unmatched pattern %i ",name);
        fprintf(stderr,"%s",constructors[name]);
        fprintf(stderr," at pc: %i",pc);
        printf("\n");  
        exit(1);
      }
      break;
    }
    case SPLIT:    {
      int n = code[pc+1];
      int a = getAddress(pop());
      int i=n;

      for (;i>0;i--)
       push(heap[a+2+i]);
      pc=pc+2;
      break;
    }
  case PRINT:    {printf("start  von Print\n");print();printf("ende von Print\n");pc=pc+1;break;}
    case CCALL:    {	
      void(*f)();
      f=(void(*)())code[pc+1];
      f();
      pc=pc+2;
      break;
    }
    case END:    {pc=-1;break;}
    case NOP:    {pc=pc+1;break;}   
    case GETRUNTIME:    {
      pc=pc+1;
      int args[]={}; 
      int args2[]={0,0}; 
      int a= ncon(NIL,0,args);
      push(a);
      int i=progArgsC-1;
      for (;i>0;i--){
	pushCString(progArgsV[i]);
        args2[0]=pop();
        args2[1]=pop();
        a=ncon(CONS,2,args2);
        push(a);
      }
      break;
    }   
  }
}

void eval(){while (pc>=0){step();}}


/*---------garbage collection---------------------------------------*/
void copyGlobals();
void copyStack();
void copyHeap();
int copy(int adr);
void follow(int adr);

int* toSpace;

int from;
int to;

void gc(int needs){
  fprintf(stderr,"gc: old heap %i, cells %i, ",nextHeap,needs);

  fromSpace = heap;
  to=nextHeap;

  heapSize=lastUsed>heapSize/2?5*lastUsed+4*needs:heapSize+4*needs;
  fprintf(stderr,"new size %i, ",heapSize);  
  fflush(stderr);

  toSpace=(int*)malloc(sizeof(int[heapSize]));
  heap=toSpace;

  fprintf(stderr," A");
  fflush(stderr);

  nextHeap=0;
  copyGlobals();
  fprintf(stderr,"G");

  fflush(stderr);
  copyStack();
  fprintf(stderr,"S");
  fflush(stderr);
  from=0;

  copyHeap();
  fprintf(stderr,"H ");
  fflush(stderr);

  free(fromSpace);

  fprintf(stderr,"new heap %i\n",nextHeap);
  fflush(stderr);

  lastUsed=nextHeap;
  lastNeeded=needs;
}

void copyGlobals(){
  int i=0;
  for(;i<(*numberOfGlobals);i++){copy(i*3);}
}

void copyStack(){
  int currentBottom=stackBottom;
  int currentNext=nextStack;
  int i=currentBottom;
  while(currentBottom>=0){
    for(;i<currentNext;i++){
      stack[i]=copy(stack[i]);
    }

    if (currentBottom==0)break;

    currentNext=currentBottom-2;
    currentBottom=stack[currentBottom-1];

    i=currentBottom;
  }
}


void copyHeap(){
  to=nextHeap;
  while (from<to){
    while (from<to){
      follow(from);
    }
    from=to;
    to=nextHeap;
  }
}

int copy(int adr){
  int n=(fromSpace)[adr];
  int result=0;
  switch (n) {
    case FWD:{return (fromSpace)[adr+1];}
    case IND:{result=nind((fromSpace)[adr+1]);break;}
    case IDN:{result=nind((fromSpace)[adr+1]);break;}
    case NUM:{result=nnum((fromSpace)[adr+1]);break;}
    case CHR:{result=nchr((fromSpace)[adr+1]);break;}
    case APP:{result=napp((fromSpace)[adr+1],(fromSpace)[adr+2]);break;}
    case CON:{
      int name=(fromSpace)[adr+1];
      int argc=(fromSpace)[adr+2];
      int argv[argc];
      int i=0;
      for (;i<argc;i++){argv[i]=(fromSpace)[adr+3+i];}
      result=ncon(name,argc,argv);
      break;
    }
    case GLB:{result= nglb((fromSpace)[adr+1],(fromSpace)[adr+2]);break;}
  }
  (fromSpace)[adr]=FWD;
  (fromSpace)[adr+1]=result;
  return result;
}

int getSize(int a){
  int n=heap[a];
  switch (n) {
    case APP:{return 3;}
    case GLB:{return 3;}
    case CON:{return 3+heap[a+2];}
    case IDN:{return heap[a+2];}
  }
  return 2;
}

void follow(int adr){
  int n=(toSpace)[adr];
  switch (n) {
    case IND:{(toSpace)[adr+1]=copy((toSpace)[adr+1])
             ;from=from+2;break;}
    case IDN:{(toSpace)[adr+1]=copy((toSpace)[adr+1])
             ;from=from+(toSpace[adr+2]);break;}
    case APP:{
      (toSpace)[adr+1]=copy((toSpace)[adr+1]);
      (toSpace)[adr+2]=copy((toSpace)[adr+2]);
      from=from+3;
      break;}
    case CON:{
      int argc=(toSpace)[adr+2];
      from=from+3+argc;      
      for(;argc>0;argc--){
        (toSpace)[adr+2+argc]=copy((toSpace)[adr+2+argc]);
      }
      break;}
    case GLB:{from=from+3;break;}
    default:{from=from+2;break;}
  }
}

void check(int i){if (heapSize<nextHeap+i) gc(i);}


